PROC TABULATE DATA=ghpb08 NOSEPS MISSING;
CLASS health_only ENT2 health_type INS3;
LABEL SUBTL_ACT_RTD_SEP_CNT="Total Participants (thousands) 2/"
	  TOT_ACTIVE_PARTCP_CNT="Active Participants (thousands) 3/"
	  TOT_ASSETS_EOY_AMT="Total Assets (millions) 4/"
	  TOT_CONTRIB_AMT="Total Contributions (millions) 5/"
	  TOT_DISTRIB_BNFT_AMT="Total Benefits (millions) 6/";
VAR TOT_ACTIVE_PARTCP_CNT TOT_ASSETS_EOY_AMT SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT;
VAR TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT;
FORMAT INS3 ins3f.;
TITLE 'Table A1. Group Health Plans, Total Participants, Active Participants,';
TITLE2 'Assets, Contributions, and Benefits';
TITLE3 'by type of plan and type of insurance, 2008';
KEYLABEL ALL='Total';
TABLE All='Total Plans' INS3=' ', ALL health_only=' ' health_type=' ', 
    N='Number of Plans'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNT TOT_ACTIVE_PARTCP_CNT))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AMT TOT_CONTRIB_AMT TOT_DISTRIB_BNFT_AMT)*F=M13F. / 
    RTS=41 Box='Type of Plan'  MISSTEXT='-';

RUN;
